/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.neo4j.gis.spatial.index.curves.SpaceFillingCurveConfiguration;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.helpers.collection.BoundedIterable;
import org.neo4j.helpers.collection.CombiningIterable;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.index.internal.gbptree.GBPTree;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.IOLimiter;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexConfigProvider;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.impl.annotations.ReporterFactory;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.kernel.impl.index.schema.IndexLayout;
import org.neo4j.kernel.impl.index.schema.NativeIndexAccessor;
import org.neo4j.kernel.impl.index.schema.NativeIndexValue;
import org.neo4j.kernel.impl.index.schema.SpatialIndexCache;
import org.neo4j.kernel.impl.index.schema.SpatialIndexConfig;
import org.neo4j.kernel.impl.index.schema.SpatialIndexFiles;
import org.neo4j.kernel.impl.index.schema.SpatialIndexKey;
import org.neo4j.kernel.impl.index.schema.SpatialIndexPartReader;
import org.neo4j.kernel.impl.index.schema.SpatialIndexPopulator;
import org.neo4j.kernel.impl.index.schema.SpatialIndexReader;
import org.neo4j.kernel.impl.index.schema.SpatialIndexUpdater;
import org.neo4j.kernel.impl.index.schema.SpatialVerifyDeferredConstraint;
import org.neo4j.kernel.impl.index.schema.config.SpaceFillingCurveSettings;
import org.neo4j.kernel.impl.index.schema.fusion.FusionIndexBase;
import org.neo4j.storageengine.api.NodePropertyAccessor;
import org.neo4j.storageengine.api.schema.IndexDescriptor;
import org.neo4j.storageengine.api.schema.IndexReader;
import org.neo4j.storageengine.api.schema.StoreIndexDescriptor;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.Value;

class SpatialIndexAccessor
extends SpatialIndexCache<PartAccessor>
implements IndexAccessor {
    private final StoreIndexDescriptor descriptor;

    SpatialIndexAccessor(StoreIndexDescriptor descriptor, PageCache pageCache, FileSystemAbstraction fs, RecoveryCleanupWorkCollector recoveryCleanupWorkCollector, IndexProvider.Monitor monitor, SpatialIndexFiles spatialIndexFiles, SpaceFillingCurveConfiguration searchConfiguration, boolean readOnly2) throws IOException {
        super(new PartFactory(pageCache, fs, recoveryCleanupWorkCollector, monitor, descriptor, spatialIndexFiles, searchConfiguration, readOnly2));
        this.descriptor = descriptor;
        spatialIndexFiles.loadExistingIndexes(this);
    }

    @Override
    public void drop() {
        FusionIndexBase.forAll(NativeIndexAccessor::drop, this);
    }

    @Override
    public IndexUpdater newUpdater(IndexUpdateMode mode) {
        return new SpatialIndexUpdater(this, mode);
    }

    @Override
    public void force(IOLimiter ioLimiter) {
        for (NativeIndexAccessor part : this) {
            part.force(ioLimiter);
        }
    }

    @Override
    public void refresh() {
    }

    @Override
    public void close() {
        this.closeInstantiateCloseLock();
        FusionIndexBase.forAll(NativeIndexAccessor::close, this);
    }

    @Override
    public IndexReader newReader() {
        return new SpatialIndexReader((IndexDescriptor)this.descriptor, this);
    }

    @Override
    public BoundedIterable<Long> newAllEntriesReader() {
        final ArrayList<BoundedIterable<Long>> allEntriesReader = new ArrayList<BoundedIterable<Long>>();
        for (NativeIndexAccessor part : this) {
            allEntriesReader.add(part.newAllEntriesReader());
        }
        return new BoundedIterable<Long>(){

            @Override
            public long maxCount() {
                long sum2 = 0L;
                for (BoundedIterable part : allEntriesReader) {
                    long partMaxCount = part.maxCount();
                    if (partMaxCount == -1L) {
                        return -1L;
                    }
                    sum2 += partMaxCount;
                }
                return sum2;
            }

            @Override
            public void close() throws Exception {
                FusionIndexBase.forAll(AutoCloseable::close, allEntriesReader);
            }

            @Override
            public Iterator<Long> iterator() {
                return new CombiningIterable((Iterable)allEntriesReader).iterator();
            }
        };
    }

    @Override
    public ResourceIterator<File> snapshotFiles() {
        ArrayList<ResourceIterator<File>> snapshotFiles = new ArrayList<ResourceIterator<File>>();
        for (NativeIndexAccessor part : this) {
            snapshotFiles.add(part.snapshotFiles());
        }
        return Iterators.concatResourceIterators(snapshotFiles.iterator());
    }

    @Override
    public Map<String, Value> indexConfig() {
        HashMap<String, Value> indexConfig = new HashMap<String, Value>();
        for (NativeIndexAccessor part : this) {
            IndexConfigProvider.putAllNoOverwrite(indexConfig, part.indexConfig());
        }
        return indexConfig;
    }

    @Override
    public void verifyDeferredConstraints(NodePropertyAccessor nodePropertyAccessor) throws IndexEntryConflictException {
        for (NativeIndexAccessor part : this) {
            part.verifyDeferredConstraints(nodePropertyAccessor);
        }
    }

    @Override
    public boolean isDirty() {
        return Iterators.stream(this.iterator()).anyMatch(NativeIndexAccessor::isDirty);
    }

    @Override
    public boolean consistencyCheck(ReporterFactory reporterFactory) {
        return FusionIndexBase.consistencyCheck(this, reporterFactory);
    }

    static class PartFactory
    implements SpatialIndexCache.Factory<PartAccessor> {
        private final PageCache pageCache;
        private final FileSystemAbstraction fs;
        private final RecoveryCleanupWorkCollector recoveryCleanupWorkCollector;
        private final IndexProvider.Monitor monitor;
        private final StoreIndexDescriptor descriptor;
        private final SpatialIndexFiles spatialIndexFiles;
        private final SpaceFillingCurveConfiguration searchConfiguration;
        private final boolean readOnly;

        PartFactory(PageCache pageCache, FileSystemAbstraction fs, RecoveryCleanupWorkCollector recoveryCleanupWorkCollector, IndexProvider.Monitor monitor, StoreIndexDescriptor descriptor, SpatialIndexFiles spatialIndexFiles, SpaceFillingCurveConfiguration searchConfiguration, boolean readOnly2) {
            this.pageCache = pageCache;
            this.fs = fs;
            this.recoveryCleanupWorkCollector = recoveryCleanupWorkCollector;
            this.monitor = monitor;
            this.descriptor = descriptor;
            this.spatialIndexFiles = spatialIndexFiles;
            this.searchConfiguration = searchConfiguration;
            this.readOnly = readOnly2;
        }

        @Override
        public PartAccessor newSpatial(CoordinateReferenceSystem crs) throws IOException {
            SpatialIndexFiles.SpatialFile spatialFile = this.spatialIndexFiles.forCrs(crs);
            if (!this.fs.fileExists(spatialFile.indexFile)) {
                SpatialIndexFiles.SpatialFileLayout fileLayout = spatialFile.getLayoutForNewIndex();
                this.createEmptyIndex(fileLayout);
                return this.createPartAccessor(fileLayout);
            }
            return this.createPartAccessor(spatialFile.getLayoutForExistingIndex(this.pageCache));
        }

        private PartAccessor createPartAccessor(SpatialIndexFiles.SpatialFileLayout fileLayout) throws IOException {
            return new PartAccessor(this.pageCache, this.fs, fileLayout, this.recoveryCleanupWorkCollector, this.monitor, this.descriptor, this.searchConfiguration, this.readOnly);
        }

        private void createEmptyIndex(SpatialIndexFiles.SpatialFileLayout fileLayout) {
            SpatialIndexPopulator.PartPopulator populator = new SpatialIndexPopulator.PartPopulator(this.pageCache, this.fs, fileLayout, this.monitor, this.descriptor, this.searchConfiguration);
            populator.create();
            populator.close(true);
        }
    }

    static class PartAccessor
    extends NativeIndexAccessor<SpatialIndexKey, NativeIndexValue> {
        private final IndexLayout<SpatialIndexKey, NativeIndexValue> layout;
        private final StoreIndexDescriptor descriptor;
        private final SpaceFillingCurveConfiguration searchConfiguration;
        private CoordinateReferenceSystem crs;
        private SpaceFillingCurveSettings settings;

        PartAccessor(PageCache pageCache, FileSystemAbstraction fs, SpatialIndexFiles.SpatialFileLayout fileLayout, RecoveryCleanupWorkCollector recoveryCleanupWorkCollector, IndexProvider.Monitor monitor, StoreIndexDescriptor descriptor, SpaceFillingCurveConfiguration searchConfiguration, boolean readOnly2) {
            super(pageCache, fs, fileLayout.getIndexFile(), fileLayout.layout, monitor, descriptor, GBPTree.NO_HEADER_WRITER, readOnly2);
            this.layout = fileLayout.layout;
            this.descriptor = descriptor;
            this.searchConfiguration = searchConfiguration;
            this.crs = fileLayout.spatialFile.crs;
            this.settings = fileLayout.settings;
            this.instantiateTree(recoveryCleanupWorkCollector, this.headerWriter);
        }

        @Override
        public SpatialIndexPartReader<NativeIndexValue> newReader() {
            this.assertOpen();
            return new SpatialIndexPartReader<NativeIndexValue>(this.tree, this.layout, (IndexDescriptor)this.descriptor, this.searchConfiguration);
        }

        @Override
        public void verifyDeferredConstraints(NodePropertyAccessor nodePropertyAccessor) throws IndexEntryConflictException {
            SpatialVerifyDeferredConstraint.verify(nodePropertyAccessor, this.layout, (GBPTree<SpatialIndexKey, NativeIndexValue>)this.tree, this.descriptor);
            super.verifyDeferredConstraints(nodePropertyAccessor);
        }

        @Override
        public Map<String, Value> indexConfig() {
            HashMap<String, Value> map2 = new HashMap<String, Value>();
            SpatialIndexConfig.addSpatialConfig(map2, this.crs, this.settings);
            return map2;
        }
    }
}

