/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.neo4j.index.internal.gbptree.Header;

class NativeIndexHeaderReader
implements Header.Reader {
    private final Header.Reader additionalReader;
    byte state;
    String failureMessage;

    NativeIndexHeaderReader(Header.Reader additionalReader) {
        this.additionalReader = additionalReader;
    }

    public void read(ByteBuffer headerData) {
        try {
            this.state = headerData.get();
            if (this.state == 0) {
                this.failureMessage = NativeIndexHeaderReader.readFailureMessage(headerData);
            } else {
                this.additionalReader.read(headerData);
            }
        }
        catch (BufferUnderflowException e) {
            this.state = 0;
            this.failureMessage = String.format("Could not read header, most likely caused by index not being fully constructed. Index needs to be recreated. Stacktrace:%n%s", ExceptionUtils.getStackTrace(e));
        }
    }

    static String readFailureMessage(ByteBuffer headerData) {
        short messageLength = headerData.getShort();
        byte[] failureMessageBytes = new byte[messageLength];
        headerData.get(failureMessageBytes);
        return new String(failureMessageBytes, StandardCharsets.UTF_8);
    }
}

