/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.util.List;
import org.neo4j.gis.spatial.index.curves.SpaceFillingCurve;
import org.neo4j.gis.spatial.index.curves.SpaceFillingCurveConfiguration;
import org.neo4j.index.internal.gbptree.GBPTree;
import org.neo4j.internal.kernel.api.IndexOrder;
import org.neo4j.internal.kernel.api.IndexQuery;
import org.neo4j.kernel.impl.api.schema.BridgingIndexProgressor;
import org.neo4j.kernel.impl.index.schema.CapabilityValidator;
import org.neo4j.kernel.impl.index.schema.GenericKey;
import org.neo4j.kernel.impl.index.schema.GenericNativeIndexProvider;
import org.neo4j.kernel.impl.index.schema.IndexLayout;
import org.neo4j.kernel.impl.index.schema.NativeIndexKey;
import org.neo4j.kernel.impl.index.schema.NativeIndexReader;
import org.neo4j.kernel.impl.index.schema.NativeIndexValue;
import org.neo4j.kernel.impl.index.schema.config.IndexSpecificSpaceFillingCurveSettingsCache;
import org.neo4j.storageengine.api.schema.IndexDescriptor;
import org.neo4j.storageengine.api.schema.IndexProgressor;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueGroup;
import org.neo4j.values.storable.Values;

class GenericNativeIndexReader
extends NativeIndexReader<GenericKey, NativeIndexValue> {
    private final IndexSpecificSpaceFillingCurveSettingsCache spaceFillingCurveSettings;
    private final SpaceFillingCurveConfiguration configuration;

    GenericNativeIndexReader(GBPTree<GenericKey, NativeIndexValue> tree, IndexLayout<GenericKey, NativeIndexValue> layout, IndexDescriptor descriptor, IndexSpecificSpaceFillingCurveSettingsCache spaceFillingCurveSettings, SpaceFillingCurveConfiguration configuration) {
        super(tree, layout, descriptor);
        this.spaceFillingCurveSettings = spaceFillingCurveSettings;
        this.configuration = configuration;
    }

    @Override
    public boolean hasFullValuePrecision(IndexQuery ... predicates) {
        for (IndexQuery predicate : predicates) {
            ValueGroup valueGroup = predicate.valueGroup();
            if (valueGroup != ValueGroup.GEOMETRY_ARRAY && valueGroup != ValueGroup.GEOMETRY) continue;
            return false;
        }
        return true;
    }

    @Override
    void validateQuery(IndexOrder indexOrder, IndexQuery[] predicates) {
        CapabilityValidator.validateQuery(GenericNativeIndexProvider.CAPABILITY, indexOrder, predicates);
    }

    @Override
    public void query(IndexProgressor.NodeValueClient client, IndexOrder indexOrder, boolean needsValues, IndexQuery ... query) {
        IndexQuery.GeometryRangePredicate geometryRangePredicate = this.getGeometryRangePredicateIfAny(query);
        if (geometryRangePredicate != null) {
            this.validateQuery(indexOrder, query);
            try {
                BridgingIndexProgressor multiProgressor = new BridgingIndexProgressor(client, this.descriptor.schema().getPropertyIds());
                client.initialize(this.descriptor, (IndexProgressor)multiProgressor, query, indexOrder, needsValues);
                double[] from2 = geometryRangePredicate.from() == null ? null : geometryRangePredicate.from().coordinate();
                double[] to2 = geometryRangePredicate.to() == null ? null : geometryRangePredicate.to().coordinate();
                CoordinateReferenceSystem crs = geometryRangePredicate.crs();
                SpaceFillingCurve curve = this.spaceFillingCurveSettings.forCrs(crs, false);
                List ranges = curve.getTilesIntersectingEnvelope(from2, to2, this.configuration);
                for (SpaceFillingCurve.LongRange range2 : ranges) {
                    GenericKey treeKeyFrom = (GenericKey)this.layout.newKey();
                    GenericKey treeKeyTo = (GenericKey)this.layout.newKey();
                    this.initializeFromToKeys(treeKeyFrom, treeKeyTo);
                    boolean needFiltering = this.initializeRangeForGeometrySubQuery(treeKeyFrom, treeKeyTo, query, crs, range2);
                    this.startSeekForInitializedRange(multiProgressor, treeKeyFrom, treeKeyTo, query, indexOrder, needFiltering, needsValues);
                }
            }
            catch (IllegalArgumentException e) {
                client.initialize(this.descriptor, IndexProgressor.EMPTY, query, indexOrder, needsValues);
            }
        } else {
            super.query(client, indexOrder, needsValues, query);
        }
    }

    private boolean initializeRangeForGeometrySubQuery(GenericKey treeKeyFrom, GenericKey treeKeyTo, IndexQuery[] query, CoordinateReferenceSystem crs, SpaceFillingCurve.LongRange range2) {
        boolean needsFiltering = false;
        block7: for (int i = 0; i < query.length; ++i) {
            IndexQuery predicate = query[i];
            switch (predicate.type()) {
                case exists: {
                    treeKeyFrom.initValueAsLowest(i, ValueGroup.UNKNOWN);
                    treeKeyTo.initValueAsHighest(i, ValueGroup.UNKNOWN);
                    continue block7;
                }
                case exact: {
                    IndexQuery.ExactPredicate exactPredicate = (IndexQuery.ExactPredicate)predicate;
                    treeKeyFrom.initFromValue(i, exactPredicate.value(), NativeIndexKey.Inclusion.NEUTRAL);
                    treeKeyTo.initFromValue(i, exactPredicate.value(), NativeIndexKey.Inclusion.NEUTRAL);
                    continue block7;
                }
                case range: {
                    if (this.isGeometryRangeQuery(predicate)) {
                        treeKeyFrom.stateSlot(i).writePointDerived(crs, range2.min, NativeIndexKey.Inclusion.LOW);
                        treeKeyTo.stateSlot(i).writePointDerived(crs, range2.max + 1L, NativeIndexKey.Inclusion.HIGH);
                        continue block7;
                    }
                    IndexQuery.RangePredicate rangePredicate = (IndexQuery.RangePredicate)predicate;
                    GenericNativeIndexReader.initFromForRange(i, rangePredicate, treeKeyFrom);
                    GenericNativeIndexReader.initToForRange(i, rangePredicate, treeKeyTo);
                    continue block7;
                }
                case stringPrefix: {
                    IndexQuery.StringPrefixPredicate prefixPredicate = (IndexQuery.StringPrefixPredicate)predicate;
                    treeKeyFrom.stateSlot(i).initAsPrefixLow(prefixPredicate.prefix());
                    treeKeyTo.stateSlot(i).initAsPrefixHigh(prefixPredicate.prefix());
                    continue block7;
                }
                case stringSuffix: 
                case stringContains: {
                    treeKeyFrom.initValueAsLowest(i, ValueGroup.TEXT);
                    treeKeyTo.initValueAsHighest(i, ValueGroup.TEXT);
                    needsFiltering = true;
                    continue block7;
                }
                default: {
                    throw new IllegalArgumentException("IndexQuery of type " + predicate.type() + " is not supported.");
                }
            }
        }
        return needsFiltering;
    }

    @Override
    boolean initializeRangeForQuery(GenericKey treeKeyFrom, GenericKey treeKeyTo, IndexQuery[] query) {
        return this.initializeRangeForGeometrySubQuery(treeKeyFrom, treeKeyTo, query, null, null);
    }

    private static void initFromForRange(int stateSlot, IndexQuery.RangePredicate<?> rangePredicate, GenericKey treeKeyFrom) {
        Value fromValue = rangePredicate.fromValue();
        if (fromValue == Values.NO_VALUE) {
            treeKeyFrom.initValueAsLowest(stateSlot, rangePredicate.valueGroup());
        } else {
            treeKeyFrom.initFromValue(stateSlot, fromValue, GenericNativeIndexReader.fromInclusion(rangePredicate));
            treeKeyFrom.setCompareId(true);
        }
    }

    private static void initToForRange(int stateSlot, IndexQuery.RangePredicate<?> rangePredicate, GenericKey treeKeyTo) {
        Value toValue = rangePredicate.toValue();
        if (toValue == Values.NO_VALUE) {
            treeKeyTo.initValueAsHighest(stateSlot, rangePredicate.valueGroup());
        } else {
            treeKeyTo.initFromValue(stateSlot, toValue, GenericNativeIndexReader.toInclusion(rangePredicate));
            treeKeyTo.setCompareId(true);
        }
    }

    private static NativeIndexKey.Inclusion fromInclusion(IndexQuery.RangePredicate<?> rangePredicate) {
        return rangePredicate.fromInclusive() ? NativeIndexKey.Inclusion.LOW : NativeIndexKey.Inclusion.HIGH;
    }

    private static NativeIndexKey.Inclusion toInclusion(IndexQuery.RangePredicate<?> rangePredicate) {
        return rangePredicate.toInclusive() ? NativeIndexKey.Inclusion.HIGH : NativeIndexKey.Inclusion.LOW;
    }

    private IndexQuery.GeometryRangePredicate getGeometryRangePredicateIfAny(IndexQuery[] predicates) {
        for (IndexQuery predicate : predicates) {
            if (!this.isGeometryRangeQuery(predicate)) continue;
            return (IndexQuery.GeometryRangePredicate)predicate;
        }
        return null;
    }

    private boolean isGeometryRangeQuery(IndexQuery predicate) {
        return predicate instanceof IndexQuery.GeometryRangePredicate;
    }
}

