/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.state;

import java.io.IOException;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.collections.api.LazyIterable;
import org.eclipse.collections.api.LazyLongIterable;
import org.eclipse.collections.api.LongIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bag.MutableBag;
import org.eclipse.collections.api.bag.primitive.MutableBooleanBag;
import org.eclipse.collections.api.bag.primitive.MutableByteBag;
import org.eclipse.collections.api.bag.primitive.MutableCharBag;
import org.eclipse.collections.api.bag.primitive.MutableDoubleBag;
import org.eclipse.collections.api.bag.primitive.MutableFloatBag;
import org.eclipse.collections.api.bag.primitive.MutableIntBag;
import org.eclipse.collections.api.bag.primitive.MutableLongBag;
import org.eclipse.collections.api.bag.primitive.MutableShortBag;
import org.eclipse.collections.api.bag.sorted.MutableSortedBag;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.function.Function0;
import org.eclipse.collections.api.block.function.Function2;
import org.eclipse.collections.api.block.function.primitive.BooleanFunction;
import org.eclipse.collections.api.block.function.primitive.ByteFunction;
import org.eclipse.collections.api.block.function.primitive.CharFunction;
import org.eclipse.collections.api.block.function.primitive.DoubleFunction;
import org.eclipse.collections.api.block.function.primitive.DoubleObjectToDoubleFunction;
import org.eclipse.collections.api.block.function.primitive.FloatFunction;
import org.eclipse.collections.api.block.function.primitive.FloatObjectToFloatFunction;
import org.eclipse.collections.api.block.function.primitive.IntFunction;
import org.eclipse.collections.api.block.function.primitive.IntObjectToIntFunction;
import org.eclipse.collections.api.block.function.primitive.LongFunction;
import org.eclipse.collections.api.block.function.primitive.LongObjectToLongFunction;
import org.eclipse.collections.api.block.function.primitive.LongToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ShortFunction;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.block.predicate.Predicate2;
import org.eclipse.collections.api.block.predicate.primitive.LongObjectPredicate;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.block.procedure.Procedure2;
import org.eclipse.collections.api.block.procedure.primitive.LongLongProcedure;
import org.eclipse.collections.api.block.procedure.primitive.LongObjectProcedure;
import org.eclipse.collections.api.block.procedure.primitive.LongProcedure;
import org.eclipse.collections.api.block.procedure.primitive.ObjectIntProcedure;
import org.eclipse.collections.api.collection.primitive.MutableBooleanCollection;
import org.eclipse.collections.api.collection.primitive.MutableByteCollection;
import org.eclipse.collections.api.collection.primitive.MutableCharCollection;
import org.eclipse.collections.api.collection.primitive.MutableDoubleCollection;
import org.eclipse.collections.api.collection.primitive.MutableFloatCollection;
import org.eclipse.collections.api.collection.primitive.MutableIntCollection;
import org.eclipse.collections.api.collection.primitive.MutableLongCollection;
import org.eclipse.collections.api.collection.primitive.MutableShortCollection;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.map.MutableMap;
import org.eclipse.collections.api.map.primitive.ImmutableLongObjectMap;
import org.eclipse.collections.api.map.primitive.LongObjectMap;
import org.eclipse.collections.api.map.primitive.MutableLongLongMap;
import org.eclipse.collections.api.map.primitive.MutableLongObjectMap;
import org.eclipse.collections.api.map.primitive.MutableObjectDoubleMap;
import org.eclipse.collections.api.map.primitive.MutableObjectLongMap;
import org.eclipse.collections.api.map.sorted.MutableSortedMap;
import org.eclipse.collections.api.multimap.MutableMultimap;
import org.eclipse.collections.api.multimap.bag.MutableBagMultimap;
import org.eclipse.collections.api.partition.bag.PartitionMutableBag;
import org.eclipse.collections.api.set.MutableSet;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.api.set.sorted.MutableSortedSet;
import org.eclipse.collections.api.tuple.Pair;
import org.eclipse.collections.api.tuple.primitive.LongLongPair;
import org.eclipse.collections.api.tuple.primitive.LongObjectPair;
import org.eclipse.collections.impl.lazy.AbstractLazyIterable;
import org.eclipse.collections.impl.lazy.LazyIterableAdapter;
import org.eclipse.collections.impl.map.mutable.primitive.SynchronizedLongObjectMap;
import org.eclipse.collections.impl.map.mutable.primitive.UnmodifiableLongObjectMap;
import org.eclipse.collections.impl.tuple.primitive.PrimitiveTuples;
import org.neo4j.kernel.impl.api.state.ValuesContainer;
import org.neo4j.values.storable.Value;

public class ValuesMap
implements MutableLongObjectMap<Value> {
    private static final long NONE = -1L;
    private final MutableLongLongMap refs;
    private final ValuesContainer valuesContainer;

    public ValuesMap(MutableLongLongMap refs, ValuesContainer valuesContainer) {
        this.valuesContainer = valuesContainer;
        this.refs = refs;
    }

    public int size() {
        return this.refs.size();
    }

    public boolean isEmpty() {
        return this.refs.isEmpty();
    }

    public Value getFirst() {
        throw new UnsupportedOperationException();
    }

    public Value getLast() {
        throw new UnsupportedOperationException();
    }

    public boolean contains(Object object) {
        throw new UnsupportedOperationException();
    }

    public boolean containsAllIterable(Iterable<?> source) {
        throw new UnsupportedOperationException();
    }

    public boolean containsAll(Collection<?> source) {
        throw new UnsupportedOperationException();
    }

    public boolean containsAllArguments(Object ... elements) {
        throw new UnsupportedOperationException();
    }

    public RichIterable<LongObjectPair<Value>> keyValuesView() {
        return new KeyValuesView();
    }

    public Value put(long key, Value value2) {
        Objects.requireNonNull(value2, "Cannot put null values");
        Value prev = this.get(key);
        long ref = this.valuesContainer.add(value2);
        this.refs.put(key, ref);
        return prev;
    }

    public void putAll(LongObjectMap<? extends Value> map2) {
        map2.forEachKeyValue(this::put);
    }

    public Value get(long key) {
        long ref = this.refs.getIfAbsent(key, -1L);
        return ref == -1L ? null : this.valuesContainer.get(ref);
    }

    public Value getIfAbsentPut(long key, Value value2) {
        Value existing = this.get(key);
        if (existing != null) {
            return existing;
        }
        this.put(key, value2);
        return value2;
    }

    public Value getIfAbsentPut(long key, Function0<? extends Value> supplier) {
        Value existing = this.get(key);
        if (existing != null) {
            return existing;
        }
        Value value2 = (Value)supplier.value();
        this.put(key, value2);
        return value2;
    }

    public Value getIfAbsentPutWithKey(long key, LongToObjectFunction<? extends Value> function) {
        Value existing = this.get(key);
        if (existing != null) {
            return existing;
        }
        Value value2 = (Value)function.valueOf(key);
        this.put(key, value2);
        return value2;
    }

    public <P> Value getIfAbsentPutWith(long key, Function<? super P, ? extends Value> function, P parameter) {
        Value existing = this.get(key);
        if (existing != null) {
            return existing;
        }
        Value value2 = (Value)function.valueOf(parameter);
        this.put(key, value2);
        return value2;
    }

    public Value updateValue(long key, Function0<? extends Value> factory, Function<? super Value, ? extends Value> function) {
        throw new UnsupportedOperationException();
    }

    public <P> Value updateValueWith(long key, Function0<? extends Value> factory, Function2<? super Value, ? super P, ? extends Value> function, P parameter) {
        throw new UnsupportedOperationException();
    }

    public MutableObjectLongMap<Value> flipUniqueValues() {
        throw new UnsupportedOperationException();
    }

    public MutableLongObjectMap<Value> tap(Procedure<? super Value> procedure) {
        this.forEachValue(procedure);
        return this;
    }

    public void each(Procedure<? super Value> procedure) {
        this.refs.forEachKey((LongProcedure & Serializable)ref -> {
            Value value2 = this.valuesContainer.get(ref);
            procedure.value((Object)value2);
        });
    }

    public MutableLongObjectMap<Value> select(LongObjectPredicate<? super Value> predicate) {
        throw new UnsupportedOperationException();
    }

    public MutableLongObjectMap<Value> reject(LongObjectPredicate<? super Value> predicate) {
        throw new UnsupportedOperationException();
    }

    public ImmutableLongObjectMap<Value> toImmutable() {
        throw new UnsupportedOperationException();
    }

    public MutableLongSet keySet() {
        return this.refs.keySet().asUnmodifiable();
    }

    public LazyLongIterable keysView() {
        return this.refs.keysView();
    }

    public ValuesMap withKeyValue(long key, Value value2) {
        this.put(key, value2);
        return this;
    }

    public ValuesMap withoutKey(long key) {
        this.removeKey(key);
        return this;
    }

    public ValuesMap withoutAllKeys(LongIterable keys) {
        keys.forEach(this::removeKey);
        return this;
    }

    public MutableLongObjectMap<Value> asUnmodifiable() {
        return new UnmodifiableLongObjectMap((MutableLongObjectMap)this);
    }

    public MutableLongObjectMap<Value> asSynchronized() {
        return new SynchronizedLongObjectMap((MutableLongObjectMap)this);
    }

    public Value getIfAbsent(long key, Function0<? extends Value> ifAbsent) {
        Value existing = this.get(key);
        if (existing != null) {
            return existing;
        }
        return (Value)ifAbsent.value();
    }

    public boolean containsKey(long key) {
        return this.refs.containsKey(key);
    }

    public Value removeKey(long key) {
        long ref = this.refs.removeKeyIfAbsent(key, -1L);
        return ref == -1L ? null : this.valuesContainer.remove(ref);
    }

    public Value remove(long key) {
        return this.removeKey(key);
    }

    public void clear() {
        this.refs.clear();
    }

    public <K, VV> MutableMap<K, VV> aggregateInPlaceBy(Function<? super Value, ? extends K> groupBy2, Function0<? extends VV> zeroValueFactory, Procedure2<? super VV, ? super Value> mutatingAggregator) {
        throw new UnsupportedOperationException();
    }

    public <K, VV> MutableMap<K, VV> aggregateBy(Function<? super Value, ? extends K> groupBy2, Function0<? extends VV> zeroValueFactory, Function2<? super VV, ? super Value, ? extends VV> nonMutatingAggregator) {
        throw new UnsupportedOperationException();
    }

    public <VV> MutableBagMultimap<VV, Value> groupByEach(Function<? super Value, ? extends Iterable<VV>> function) {
        throw new UnsupportedOperationException();
    }

    public <V, R extends MutableMultimap<V, Value>> R groupByEach(Function<? super Value, ? extends Iterable<V>> function, R target) {
        throw new UnsupportedOperationException();
    }

    public <VV> MutableBagMultimap<VV, Value> groupBy(Function<? super Value, ? extends VV> function) {
        throw new UnsupportedOperationException();
    }

    public <V, R extends MutableMultimap<V, Value>> R groupBy(Function<? super Value, ? extends V> function, R target) {
        throw new UnsupportedOperationException();
    }

    public <VV> MutableMap<VV, Value> groupByUniqueKey(Function<? super Value, ? extends VV> function) {
        throw new UnsupportedOperationException();
    }

    public <V, R extends MutableMap<V, Value>> R groupByUniqueKey(Function<? super Value, ? extends V> function, R target) {
        throw new UnsupportedOperationException();
    }

    public <VV> MutableBag<VV> collectIf(Predicate<? super Value> predicate, Function<? super Value, ? extends VV> function) {
        throw new UnsupportedOperationException();
    }

    public <V, R extends Collection<V>> R collectIf(Predicate<? super Value> predicate, Function<? super Value, ? extends V> function, R target) {
        throw new UnsupportedOperationException();
    }

    public <VV> MutableBag<VV> collect(Function<? super Value, ? extends VV> function) {
        throw new UnsupportedOperationException();
    }

    public <V, R extends Collection<V>> R collect(Function<? super Value, ? extends V> function, R target) {
        throw new UnsupportedOperationException();
    }

    public MutableBooleanBag collectBoolean(BooleanFunction<? super Value> booleanFunction) {
        throw new UnsupportedOperationException();
    }

    public <R extends MutableBooleanCollection> R collectBoolean(BooleanFunction<? super Value> booleanFunction, R target) {
        throw new UnsupportedOperationException();
    }

    public MutableByteBag collectByte(ByteFunction<? super Value> byteFunction) {
        throw new UnsupportedOperationException();
    }

    public <R extends MutableByteCollection> R collectByte(ByteFunction<? super Value> byteFunction, R target) {
        throw new UnsupportedOperationException();
    }

    public MutableCharBag collectChar(CharFunction<? super Value> charFunction) {
        throw new UnsupportedOperationException();
    }

    public <R extends MutableCharCollection> R collectChar(CharFunction<? super Value> charFunction, R target) {
        throw new UnsupportedOperationException();
    }

    public MutableDoubleBag collectDouble(DoubleFunction<? super Value> doubleFunction) {
        throw new UnsupportedOperationException();
    }

    public <R extends MutableDoubleCollection> R collectDouble(DoubleFunction<? super Value> doubleFunction, R target) {
        throw new UnsupportedOperationException();
    }

    public MutableFloatBag collectFloat(FloatFunction<? super Value> floatFunction) {
        throw new UnsupportedOperationException();
    }

    public <R extends MutableFloatCollection> R collectFloat(FloatFunction<? super Value> floatFunction, R target) {
        throw new UnsupportedOperationException();
    }

    public MutableIntBag collectInt(IntFunction<? super Value> intFunction) {
        throw new UnsupportedOperationException();
    }

    public <R extends MutableIntCollection> R collectInt(IntFunction<? super Value> intFunction, R target) {
        throw new UnsupportedOperationException();
    }

    public MutableLongBag collectLong(LongFunction<? super Value> longFunction) {
        throw new UnsupportedOperationException();
    }

    public <R extends MutableLongCollection> R collectLong(LongFunction<? super Value> longFunction, R target) {
        throw new UnsupportedOperationException();
    }

    public MutableShortBag collectShort(ShortFunction<? super Value> shortFunction) {
        throw new UnsupportedOperationException();
    }

    public <R extends MutableShortCollection> R collectShort(ShortFunction<? super Value> shortFunction, R target) {
        throw new UnsupportedOperationException();
    }

    public <P, VV> MutableBag<VV> collectWith(Function2<? super Value, ? super P, ? extends VV> function, P parameter) {
        throw new UnsupportedOperationException();
    }

    public <P, V, R extends Collection<V>> R collectWith(Function2<? super Value, ? super P, ? extends V> function, P parameter, R targetCollection) {
        throw new UnsupportedOperationException();
    }

    public <VV> MutableBag<VV> flatCollect(Function<? super Value, ? extends Iterable<VV>> function) {
        throw new UnsupportedOperationException();
    }

    public <V, R extends Collection<V>> R flatCollect(Function<? super Value, ? extends Iterable<V>> function, R target) {
        throw new UnsupportedOperationException();
    }

    public Value detect(Predicate<? super Value> predicate) {
        throw new UnsupportedOperationException();
    }

    public <P> Value detectWith(Predicate2<? super Value, ? super P> predicate, P parameter) {
        throw new UnsupportedOperationException();
    }

    public Optional<Value> detectOptional(Predicate<? super Value> predicate) {
        throw new UnsupportedOperationException();
    }

    public <P> Optional<Value> detectWithOptional(Predicate2<? super Value, ? super P> predicate, P parameter) {
        throw new UnsupportedOperationException();
    }

    public <P> Value detectWithIfNone(Predicate2<? super Value, ? super P> predicate, P parameter, Function0<? extends Value> function) {
        throw new UnsupportedOperationException();
    }

    public int count(Predicate<? super Value> predicate) {
        throw new UnsupportedOperationException();
    }

    public <P> int countWith(Predicate2<? super Value, ? super P> predicate, P parameter) {
        throw new UnsupportedOperationException();
    }

    public boolean anySatisfy(Predicate<? super Value> predicate) {
        throw new UnsupportedOperationException();
    }

    public <P> boolean anySatisfyWith(Predicate2<? super Value, ? super P> predicate, P parameter) {
        throw new UnsupportedOperationException();
    }

    public boolean allSatisfy(Predicate<? super Value> predicate) {
        throw new UnsupportedOperationException();
    }

    public <P> boolean allSatisfyWith(Predicate2<? super Value, ? super P> predicate, P parameter) {
        throw new UnsupportedOperationException();
    }

    public boolean noneSatisfy(Predicate<? super Value> predicate) {
        throw new UnsupportedOperationException();
    }

    public <P> boolean noneSatisfyWith(Predicate2<? super Value, ? super P> predicate, P parameter) {
        throw new UnsupportedOperationException();
    }

    public <IV> IV injectInto(IV injectedValue, Function2<? super IV, ? super Value, ? extends IV> function) {
        throw new UnsupportedOperationException();
    }

    public int injectInto(int injectedValue, IntObjectToIntFunction<? super Value> function) {
        throw new UnsupportedOperationException();
    }

    public long injectInto(long injectedValue, LongObjectToLongFunction<? super Value> function) {
        throw new UnsupportedOperationException();
    }

    public float injectInto(float injectedValue, FloatObjectToFloatFunction<? super Value> function) {
        throw new UnsupportedOperationException();
    }

    public double injectInto(double injectedValue, DoubleObjectToDoubleFunction<? super Value> function) {
        throw new UnsupportedOperationException();
    }

    public <R extends Collection<Value>> R into(R target) {
        throw new UnsupportedOperationException();
    }

    public MutableList<Value> toList() {
        throw new UnsupportedOperationException();
    }

    public <V extends Comparable<? super V>> MutableList<Value> toSortedListBy(Function<? super Value, ? extends V> function) {
        throw new UnsupportedOperationException();
    }

    public MutableSet<Value> toSet() {
        throw new UnsupportedOperationException();
    }

    public MutableSortedSet<Value> toSortedSet() {
        throw new UnsupportedOperationException();
    }

    public MutableSortedSet<Value> toSortedSet(Comparator<? super Value> comparator2) {
        throw new UnsupportedOperationException();
    }

    public <V extends Comparable<? super V>> MutableSortedSet<Value> toSortedSetBy(Function<? super Value, ? extends V> function) {
        throw new UnsupportedOperationException();
    }

    public MutableBag<Value> toBag() {
        throw new UnsupportedOperationException();
    }

    public MutableSortedBag<Value> toSortedBag() {
        throw new UnsupportedOperationException();
    }

    public MutableSortedBag<Value> toSortedBag(Comparator<? super Value> comparator2) {
        throw new UnsupportedOperationException();
    }

    public <V extends Comparable<? super V>> MutableSortedBag<Value> toSortedBagBy(Function<? super Value, ? extends V> function) {
        throw new UnsupportedOperationException();
    }

    public <NK, NV> MutableMap<NK, NV> toMap(Function<? super Value, ? extends NK> keyFunction, Function<? super Value, ? extends NV> valueFunction) {
        throw new UnsupportedOperationException();
    }

    public <NK, NV> MutableSortedMap<NK, NV> toSortedMap(Function<? super Value, ? extends NK> keyFunction, Function<? super Value, ? extends NV> valueFunction) {
        throw new UnsupportedOperationException();
    }

    public <NK, NV> MutableSortedMap<NK, NV> toSortedMap(Comparator<? super NK> comparator2, Function<? super Value, ? extends NK> keyFunction, Function<? super Value, ? extends NV> valueFunction) {
        throw new UnsupportedOperationException();
    }

    public LazyIterable<Value> asLazy() {
        return new LazyIterableAdapter((Iterable)((Object)this));
    }

    public Object[] toArray() {
        throw new UnsupportedOperationException();
    }

    public <T> T[] toArray(T[] target) {
        throw new UnsupportedOperationException();
    }

    public Value min(Comparator<? super Value> comparator2) {
        throw new UnsupportedOperationException();
    }

    public Value max(Comparator<? super Value> comparator2) {
        throw new UnsupportedOperationException();
    }

    public Value min() {
        throw new UnsupportedOperationException();
    }

    public Value max() {
        throw new UnsupportedOperationException();
    }

    public <V extends Comparable<? super V>> Value minBy(Function<? super Value, ? extends V> function) {
        throw new UnsupportedOperationException();
    }

    public <V extends Comparable<? super V>> Value maxBy(Function<? super Value, ? extends V> function) {
        throw new UnsupportedOperationException();
    }

    public long sumOfInt(IntFunction<? super Value> function) {
        throw new UnsupportedOperationException();
    }

    public double sumOfFloat(FloatFunction<? super Value> function) {
        throw new UnsupportedOperationException();
    }

    public long sumOfLong(LongFunction<? super Value> function) {
        throw new UnsupportedOperationException();
    }

    public double sumOfDouble(DoubleFunction<? super Value> function) {
        throw new UnsupportedOperationException();
    }

    public <S> MutableBag<S> selectInstancesOf(Class<S> clazz) {
        throw new UnsupportedOperationException();
    }

    public MutableBag<Value> select(Predicate<? super Value> predicate) {
        throw new UnsupportedOperationException();
    }

    public <R extends Collection<Value>> R select(Predicate<? super Value> predicate, R target) {
        throw new UnsupportedOperationException();
    }

    public <P> MutableBag<Value> selectWith(Predicate2<? super Value, ? super P> predicate, P parameter) {
        throw new UnsupportedOperationException();
    }

    public <P, R extends Collection<Value>> R selectWith(Predicate2<? super Value, ? super P> predicate, P parameter, R targetCollection) {
        throw new UnsupportedOperationException();
    }

    public MutableBag<Value> reject(Predicate<? super Value> predicate) {
        throw new UnsupportedOperationException();
    }

    public <P> MutableBag<Value> rejectWith(Predicate2<? super Value, ? super P> predicate, P parameter) {
        throw new UnsupportedOperationException();
    }

    public <R extends Collection<Value>> R reject(Predicate<? super Value> predicate, R target) {
        throw new UnsupportedOperationException();
    }

    public <P, R extends Collection<Value>> R rejectWith(Predicate2<? super Value, ? super P> predicate, P parameter, R targetCollection) {
        throw new UnsupportedOperationException();
    }

    public PartitionMutableBag<Value> partition(Predicate<? super Value> predicate) {
        throw new UnsupportedOperationException();
    }

    public <P> PartitionMutableBag<Value> partitionWith(Predicate2<? super Value, ? super P> predicate, P parameter) {
        throw new UnsupportedOperationException();
    }

    public <S> MutableBag<Pair<Value, S>> zip(Iterable<S> that) {
        throw new UnsupportedOperationException();
    }

    public <S, R extends Collection<Pair<Value, S>>> R zip(Iterable<S> that, R target) {
        throw new UnsupportedOperationException();
    }

    public MutableSet<Pair<Value, Integer>> zipWithIndex() {
        throw new UnsupportedOperationException();
    }

    public <R extends Collection<Pair<Value, Integer>>> R zipWithIndex(R target) {
        throw new UnsupportedOperationException();
    }

    public RichIterable<RichIterable<Value>> chunk(int size2) {
        throw new UnsupportedOperationException();
    }

    public <VV> MutableObjectLongMap<VV> sumByInt(Function<? super Value, ? extends VV> groupBy2, IntFunction<? super Value> function) {
        throw new UnsupportedOperationException();
    }

    public <VV> MutableObjectDoubleMap<VV> sumByFloat(Function<? super Value, ? extends VV> groupBy2, FloatFunction<? super Value> function) {
        throw new UnsupportedOperationException();
    }

    public <VV> MutableObjectLongMap<VV> sumByLong(Function<? super Value, ? extends VV> groupBy2, LongFunction<? super Value> function) {
        throw new UnsupportedOperationException();
    }

    public <VV> MutableObjectDoubleMap<VV> sumByDouble(Function<? super Value, ? extends VV> groupBy2, DoubleFunction<? super Value> function) {
        throw new UnsupportedOperationException();
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(String.format("ValuesMap[size: %d]", this.refs.size()));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void forEachKey(LongProcedure procedure) {
        this.refs.forEachKey(procedure);
    }

    public void forEachKeyValue(LongObjectProcedure<? super Value> procedure) {
        this.refs.forEachKeyValue((LongLongProcedure & Serializable)(key, ref) -> {
            Value value2 = this.valuesContainer.get(ref);
            procedure.value(key, (Object)value2);
        });
    }

    public boolean containsValue(Object value2) {
        throw new UnsupportedOperationException();
    }

    public void forEachValue(Procedure<? super Value> procedure) {
        this.forEachKeyValue((LongObjectProcedure<? super Value>)(LongObjectProcedure & Serializable)(k, v) -> procedure.value(v));
    }

    public Collection<Value> values() {
        throw new UnsupportedOperationException();
    }

    public void forEach(Procedure<? super Value> procedure) {
        this.forEachValue(procedure);
    }

    public void forEachWithIndex(ObjectIntProcedure<? super Value> objectIntProcedure) {
        throw new UnsupportedOperationException();
    }

    public <P> void forEachWith(Procedure2<? super Value, ? super P> procedure, P parameter) {
        throw new UnsupportedOperationException();
    }

    public Iterator<Value> iterator() {
        throw new UnsupportedOperationException();
    }

    private class KeyValuesView
    extends AbstractLazyIterable<LongObjectPair<Value>> {
        private KeyValuesView() {
        }

        public void each(Procedure<? super LongObjectPair<Value>> procedure) {
            Iterator<LongObjectPair<Value>> iterator2 = this.iterator();
            while (iterator2.hasNext()) {
                LongObjectPair<Value> valueLongObjectPair = iterator2.next();
                procedure.value(valueLongObjectPair);
            }
        }

        public Iterator<LongObjectPair<Value>> iterator() {
            final Iterator refsIterator = ValuesMap.this.refs.keyValuesView().iterator();
            return new Iterator<LongObjectPair<Value>>(){

                @Override
                public boolean hasNext() {
                    return refsIterator.hasNext();
                }

                @Override
                public LongObjectPair<Value> next() {
                    LongLongPair key2ref = (LongLongPair)refsIterator.next();
                    long key = key2ref.getOne();
                    long ref = key2ref.getTwo();
                    Value value2 = ValuesMap.this.valuesContainer.get(ref);
                    return PrimitiveTuples.pair((long)key, (Object)value2);
                }
            };
        }
    }
}

