/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.configuration;

import java.lang.invoke.LambdaMetafactory;
import java.util.EnumSet;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.neo4j.graphdb.config.BaseSetting;
import org.neo4j.graphdb.config.Configuration;
import org.neo4j.graphdb.config.InvalidSettingException;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.helpers.ListenSocketAddress;
import org.neo4j.helpers.SocketAddress;
import org.neo4j.kernel.configuration.Connector;
import org.neo4j.kernel.configuration.ConnectorValidator;
import org.neo4j.kernel.configuration.HttpConnector;
import org.neo4j.kernel.configuration.Settings;

public class HttpConnectorValidator
extends ConnectorValidator {
    private static final Consumer<String> nullConsumer = s2 -> {};

    public HttpConnectorValidator() {
        super(Connector.ConnectorType.HTTP);
    }

    @Override
    @Nonnull
    protected Optional<Setting<Object>> getSettingFor(@Nonnull String settingName, @Nonnull Map<String, String> params2) {
        BaseSetting<SocketAddress> setting;
        String[] parts = settingName.split("\\.");
        String name = parts[2];
        String subsetting = parts[3];
        boolean encrypted = HttpConnectorValidator.encryptionSetting(name).apply((HttpConnector.Encryption)((Object)((Function<String, String>)params2::get))) == HttpConnector.Encryption.TLS;
        switch (subsetting) {
            case "enabled": {
                setting = (BaseSetting<ListenSocketAddress>)Settings.setting(settingName, Settings.BOOLEAN, "false");
                setting.setDescription("Enable this connector.");
                break;
            }
            case "type": {
                setting = (BaseSetting)Settings.setting(settingName, Settings.optionsObeyCase(Connector.ConnectorType.class), Settings.NO_DEFAULT);
                setting.setDeprecated(true);
                setting.setDescription("Connector type. This setting is deprecated and its value will instead be inferred from the name of the connector.");
                break;
            }
            case "encryption": {
                setting = HttpConnectorValidator.encryptionSetting(name);
                setting.setDescription("Enable TLS for this connector.");
                break;
            }
            case "address": {
                setting = Settings.listenAddress(settingName, this.defaultPort(name, params2));
                setting.setDeprecated(true);
                setting.setReplacement("dbms.connector." + name + ".listen_address");
                setting.setDescription("Address the connector should bind to. Deprecated and replaced by " + setting.replacement().get() + ".");
                break;
            }
            case "listen_address": {
                setting = Settings.listenAddress(settingName, this.defaultPort(name, params2));
                setting.setDescription("Address the connector should bind to.");
                break;
            }
            case "advertised_address": {
                setting = Settings.advertisedAddress(settingName, Settings.listenAddress(settingName, this.defaultPort(name, params2)));
                setting.setDescription("Advertised address for this connector.");
                break;
            }
            default: {
                return Optional.empty();
            }
        }
        if (this.isDeprecatedConnectorName(name) && !setting.deprecated()) {
            setting.setDeprecated(true);
            setting.setReplacement(String.format("%s.%s.%s.%s", parts[0], parts[1], encrypted ? "https" : "http", subsetting));
        }
        return Optional.of(setting);
    }

    private int defaultPort(@Nonnull String name, @Nonnull Map<String, String> rawConfig) {
        switch (name) {
            case "http": {
                return HttpConnector.Encryption.NONE.defaultPort;
            }
            case "https": {
                return HttpConnector.Encryption.TLS.defaultPort;
            }
        }
        BaseSetting<HttpConnector.Encryption> es = HttpConnectorValidator.encryptionSetting(name);
        return ((HttpConnector.Encryption)((Object)es.apply((Function<String, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, get(java.lang.Object ), (Ljava/lang/String;)Ljava/lang/String;)(rawConfig)))).defaultPort;
    }

    @Nonnull
    private static Map<String, String> assertEncryption(@Nonnull String name, @Nonnull Setting<?> setting, @Nonnull Map<String, String> rawConfig) throws InvalidSettingException {
        Map<String, String> result2 = setting.validate(rawConfig, nullConsumer);
        Optional encryption = Optional.ofNullable(setting.apply(rawConfig::get));
        if ("https".equalsIgnoreCase(name)) {
            if (encryption.isPresent() && encryption.get() != HttpConnector.Encryption.TLS) {
                throw new InvalidSettingException(String.format("'%s' is only allowed to be '%s'; not '%s'", setting.name(), HttpConnector.Encryption.TLS.name(), encryption.get()));
            }
        } else if ("http".equalsIgnoreCase(name) && encryption.isPresent() && encryption.get() != HttpConnector.Encryption.NONE) {
            throw new InvalidSettingException(String.format("'%s' is only allowed to be '%s'; not '%s'", setting.name(), HttpConnector.Encryption.NONE.name(), encryption.get()));
        }
        return result2;
    }

    @Nonnull
    public static BaseSetting<HttpConnector.Encryption> encryptionSetting(@Nonnull String name) {
        return HttpConnectorValidator.encryptionSetting(name, HttpConnector.Encryption.NONE);
    }

    @Nonnull
    public static BaseSetting<HttpConnector.Encryption> encryptionSetting(final @Nonnull String name, HttpConnector.Encryption defaultValue) {
        final Setting<HttpConnector.Encryption> s2 = Settings.setting("dbms.connector." + name + ".encryption", Settings.optionsObeyCase(HttpConnector.Encryption.class), defaultValue.name());
        return new BaseSetting<HttpConnector.Encryption>(){

            @Override
            public boolean deprecated() {
                return true;
            }

            @Override
            public Optional<String> replacement() {
                return Optional.empty();
            }

            @Override
            public boolean internal() {
                return false;
            }

            @Override
            public Optional<String> documentedDefaultValue() {
                return Optional.empty();
            }

            @Override
            public String valueDescription() {
                return Settings.describeOneOf(EnumSet.allOf(HttpConnector.Encryption.class));
            }

            @Override
            public Optional<String> description() {
                return Optional.of("Enable TLS for this connector. This is deprecated and is decided based on the connector name instead.");
            }

            @Override
            public String name() {
                return s2.name();
            }

            @Override
            public void withScope(Function<String, String> scopingRule) {
                s2.withScope(scopingRule);
            }

            @Override
            public String getDefaultValue() {
                return s2.getDefaultValue();
            }

            @Override
            public HttpConnector.Encryption from(Configuration config) {
                return (HttpConnector.Encryption)((Object)s2.from(config));
            }

            @Override
            public HttpConnector.Encryption apply(Function<String, String> stringStringFunction) {
                return (HttpConnector.Encryption)((Object)s2.apply(stringStringFunction));
            }

            @Override
            public Map<String, String> validate(Map<String, String> rawConfig, Consumer<String> warningConsumer) throws InvalidSettingException {
                Map<String, String> result2 = s2.validate(rawConfig, warningConsumer);
                HttpConnectorValidator.assertEncryption(name, s2, rawConfig);
                return result2;
            }
        };
    }
}

