/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.txstate;

import java.io.Serializable;
import java.util.function.LongConsumer;
import org.eclipse.collections.api.block.procedure.primitive.LongProcedure;
import org.eclipse.collections.api.set.primitive.LongSet;
import org.neo4j.internal.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.internal.kernel.api.exceptions.schema.ConstraintValidationException;
import org.neo4j.kernel.impl.api.CountsRecordState;
import org.neo4j.kernel.impl.api.DegreeVisitor;
import org.neo4j.kernel.impl.api.RelationshipDataExtractor;
import org.neo4j.storageengine.api.RelationshipVisitor;
import org.neo4j.storageengine.api.StorageNodeCursor;
import org.neo4j.storageengine.api.StorageReader;
import org.neo4j.storageengine.api.StorageRelationshipGroupCursor;
import org.neo4j.storageengine.api.txstate.LongDiffSets;
import org.neo4j.storageengine.api.txstate.ReadableTransactionState;
import org.neo4j.storageengine.api.txstate.TxStateVisitor;

public class TransactionCountingStateVisitor
extends TxStateVisitor.Delegator {
    private final RelationshipDataExtractor edge = new RelationshipDataExtractor();
    private final StorageReader storageReader;
    private final CountsRecordState counts;
    private final ReadableTransactionState txState;
    private final StorageNodeCursor nodeCursor;
    private final StorageRelationshipGroupCursor groupCursor;

    public TransactionCountingStateVisitor(TxStateVisitor next2, StorageReader storageReader, ReadableTransactionState txState, CountsRecordState counts) {
        super(next2);
        this.storageReader = storageReader;
        this.txState = txState;
        this.counts = counts;
        this.nodeCursor = storageReader.allocateNodeCursor();
        this.groupCursor = storageReader.allocateRelationshipGroupCursor();
    }

    public void visitCreatedNode(long id2) {
        this.counts.incrementNodeCount(-1L, 1L);
        super.visitCreatedNode(id2);
    }

    public void visitDeletedNode(long id2) {
        this.counts.incrementNodeCount(-1L, -1L);
        this.nodeCursor.single(id2);
        if (this.nodeCursor.next()) {
            this.decrementCountForLabelsAndRelationships(this.nodeCursor);
        }
        super.visitDeletedNode(id2);
    }

    private void decrementCountForLabelsAndRelationships(StorageNodeCursor node) {
        long[] labelIds;
        for (long labelId : labelIds = node.labels()) {
            this.counts.incrementNodeCount(labelId, -1L);
        }
        this.visitDegrees(node, (type, out, in2) -> this.updateRelationshipsCountsFromDegrees(labelIds, type, -out, -in2));
    }

    private void visitDegrees(StorageNodeCursor node, DegreeVisitor visitor) {
        this.groupCursor.init(node.entityReference(), node.relationshipGroupReference());
        while (this.groupCursor.next()) {
            int loopCount = this.groupCursor.loopCount();
            visitor.visitDegree(this.groupCursor.type(), this.groupCursor.outgoingCount() + loopCount, this.groupCursor.incomingCount() + loopCount);
        }
    }

    public void visitCreatedRelationship(long id2, int type, long startNode, long endNode) throws ConstraintValidationException {
        this.updateRelationshipCount(startNode, type, endNode, 1);
        super.visitCreatedRelationship(id2, type, startNode, endNode);
    }

    public void visitDeletedRelationship(long id2) {
        try {
            this.storageReader.relationshipVisit(id2, (RelationshipVisitor)this.edge);
            this.updateRelationshipCount(this.edge.startNode(), this.edge.type(), this.edge.endNode(), -1);
        }
        catch (EntityNotFoundException e) {
            throw new IllegalStateException("Relationship being deleted should exist along with its nodes.", e);
        }
        super.visitDeletedRelationship(id2);
    }

    public void visitNodeLabelChanges(long id2, LongSet added, LongSet removed) throws ConstraintValidationException {
        if (!added.isEmpty() || !removed.isEmpty()) {
            added.each((LongProcedure & Serializable)label -> this.counts.incrementNodeCount(label, 1L));
            removed.each((LongProcedure & Serializable)label -> this.counts.incrementNodeCount(label, -1L));
            this.nodeCursor.single(id2);
            if (this.nodeCursor.next()) {
                this.visitDegrees(this.nodeCursor, (type, out, in2) -> {
                    added.forEach((LongProcedure & Serializable)label -> this.updateRelationshipsCountsFromDegrees(type, label, out, in2));
                    removed.forEach((LongProcedure & Serializable)label -> this.updateRelationshipsCountsFromDegrees(type, label, -out, -in2));
                });
            }
        }
        super.visitNodeLabelChanges(id2, added, removed);
    }

    private void updateRelationshipsCountsFromDegrees(long[] labels2, int type, long outgoing, long incoming) {
        for (long label : labels2) {
            this.updateRelationshipsCountsFromDegrees(type, label, outgoing, incoming);
        }
    }

    private boolean updateRelationshipsCountsFromDegrees(int type, long label, long outgoing, long incoming) {
        this.counts.incrementRelationshipCount(label, -1, -1L, outgoing);
        this.counts.incrementRelationshipCount(-1L, -1, label, incoming);
        this.counts.incrementRelationshipCount(label, type, -1L, outgoing);
        this.counts.incrementRelationshipCount(-1L, type, label, incoming);
        return false;
    }

    private void updateRelationshipCount(long startNode, int type, long endNode, int delta) {
        this.updateRelationshipsCountsFromDegrees(type, -1L, (long)delta, 0L);
        this.visitLabels(startNode, labelId -> this.updateRelationshipsCountsFromDegrees(type, labelId, (long)delta, 0L));
        this.visitLabels(endNode, labelId -> this.updateRelationshipsCountsFromDegrees(type, labelId, 0L, (long)delta));
    }

    private void visitLabels(long nodeId, LongConsumer visitor) {
        if (this.txState.nodeIsDeletedInThisTx(nodeId)) {
            return;
        }
        if (this.txState.nodeIsAddedInThisTx(nodeId)) {
            this.txState.getNodeState(nodeId).labelDiffSets().getAdded().forEach(visitor::accept);
        } else {
            this.nodeCursor.single(nodeId);
            if (this.nodeCursor.next()) {
                long[] labels2 = this.nodeCursor.labels();
                LongDiffSets labelDiff = this.txState.getNodeState(nodeId).labelDiffSets();
                labelDiff.getAdded().forEach(visitor::accept);
                for (long label : labels2) {
                    if (labelDiff.isRemoved(label)) continue;
                    visitor.accept(label);
                }
            }
        }
    }
}

