/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.schema;

import java.util.Arrays;
import org.apache.commons.lang3.ArrayUtils;
import org.neo4j.internal.kernel.api.TokenNameLookup;
import org.neo4j.internal.kernel.api.schema.SchemaComputer;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptor;
import org.neo4j.internal.kernel.api.schema.SchemaProcessor;
import org.neo4j.internal.kernel.api.schema.SchemaUtil;
import org.neo4j.kernel.impl.locking.ResourceTypes;
import org.neo4j.storageengine.api.EntityType;
import org.neo4j.storageengine.api.lock.ResourceType;

public class LabelSchemaDescriptor
implements org.neo4j.internal.kernel.api.schema.LabelSchemaDescriptor {
    private final int labelId;
    private final int[] propertyIds;

    LabelSchemaDescriptor(int labelId, int ... propertyIds) {
        this.labelId = labelId;
        this.propertyIds = propertyIds;
    }

    public boolean isAffected(long[] entityTokenIds) {
        return ArrayUtils.contains(entityTokenIds, (long)this.labelId);
    }

    public <R> R computeWith(SchemaComputer<R> processor) {
        return (R)processor.computeSpecific((org.neo4j.internal.kernel.api.schema.LabelSchemaDescriptor)this);
    }

    public void processWith(SchemaProcessor processor) {
        processor.processSpecific((org.neo4j.internal.kernel.api.schema.LabelSchemaDescriptor)this);
    }

    public String userDescription(TokenNameLookup tokenNameLookup) {
        return String.format(":%s(%s)", tokenNameLookup.labelGetName(this.labelId), SchemaUtil.niceProperties((TokenNameLookup)tokenNameLookup, (int[])this.propertyIds));
    }

    public int getLabelId() {
        return this.labelId;
    }

    public int keyId() {
        return this.getLabelId();
    }

    public ResourceType keyType() {
        return ResourceTypes.LABEL;
    }

    public EntityType entityType() {
        return EntityType.NODE;
    }

    public SchemaDescriptor.PropertySchemaType propertySchemaType() {
        return SchemaDescriptor.PropertySchemaType.COMPLETE_ALL_TOKENS;
    }

    public int[] getPropertyIds() {
        return this.propertyIds;
    }

    public int[] getEntityTokenIds() {
        return new int[]{this.labelId};
    }

    public boolean equals(Object o) {
        if (o instanceof LabelSchemaDescriptor) {
            LabelSchemaDescriptor that = (LabelSchemaDescriptor)o;
            return this.labelId == that.getLabelId() && Arrays.equals(this.propertyIds, that.getPropertyIds());
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.propertyIds) + 31 * this.labelId;
    }

    public String toString() {
        return "LabelSchemaDescriptor( " + this.userDescription(SchemaUtil.idTokenNameLookup) + " )";
    }

    public LabelSchemaDescriptor schema() {
        return this;
    }
}

