/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.handlers;

import java.util.Map;
import java.util.Objects;
import org.neo4j.driver.internal.BookmarksHolder;
import org.neo4j.driver.internal.handlers.PullAllResponseHandler;
import org.neo4j.driver.internal.handlers.RunResponseHandler;
import org.neo4j.driver.internal.spi.Connection;
import org.neo4j.driver.internal.util.MetadataExtractor;
import org.neo4j.driver.v1.Statement;
import org.neo4j.driver.v1.Value;

public class SessionPullAllResponseHandler
extends PullAllResponseHandler {
    private final BookmarksHolder bookmarksHolder;

    public SessionPullAllResponseHandler(Statement statement2, RunResponseHandler runResponseHandler, Connection connection, BookmarksHolder bookmarksHolder, MetadataExtractor metadataExtractor) {
        super(statement2, runResponseHandler, connection, metadataExtractor);
        this.bookmarksHolder = Objects.requireNonNull(bookmarksHolder);
    }

    @Override
    protected void afterSuccess(Map<String, Value> metadata) {
        this.releaseConnection();
        this.bookmarksHolder.setBookmarks(this.metadataExtractor.extractBookmarks(metadata));
    }

    @Override
    protected void afterFailure(Throwable error) {
        this.releaseConnection();
    }

    private void releaseConnection() {
        this.connection.release();
    }
}

