/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.runtime;

import java.time.Clock;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.bolt.v1.runtime.ExecutionPlanConverter;
import org.neo4j.bolt.v1.runtime.spi.BoltResult;
import org.neo4j.cypher.result.QueryResult;
import org.neo4j.graphdb.ExecutionPlanDescription;
import org.neo4j.graphdb.InputPosition;
import org.neo4j.graphdb.Notification;
import org.neo4j.graphdb.QueryExecutionType;
import org.neo4j.graphdb.QueryStatistics;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.IntValue;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.MapValue;
import org.neo4j.values.virtual.VirtualValues;

class CypherAdapterStream
extends BoltResult {
    private final QueryResult delegate;
    private final String[] fieldNames;
    private final Clock clock;

    CypherAdapterStream(QueryResult delegate, Clock clock) {
        this.delegate = delegate;
        this.fieldNames = delegate.fieldNames();
        this.clock = clock;
    }

    @Override
    public void close() {
        this.delegate.close();
    }

    @Override
    public String[] fieldNames() {
        return this.fieldNames;
    }

    @Override
    public void accept(BoltResult.Visitor visitor) throws Exception {
        Iterable notifications;
        long start = this.clock.millis();
        this.delegate.accept(row -> {
            visitor.visit(row);
            return true;
        });
        visitor.addMetadata("result_consumed_after", (AnyValue)Values.longValue((long)(this.clock.millis() - start)));
        QueryExecutionType qt = this.delegate.executionType();
        visitor.addMetadata("type", (AnyValue)Values.stringValue((String)this.queryTypeCode(qt.queryType())));
        if (this.delegate.queryStatistics().containsUpdates()) {
            MapValue stats = this.queryStats(this.delegate.queryStatistics());
            visitor.addMetadata("stats", (AnyValue)stats);
        }
        if (qt.requestedExecutionPlanDescription()) {
            ExecutionPlanDescription rootPlanTreeNode = this.delegate.executionPlanDescription();
            String metadataFieldName = rootPlanTreeNode.hasProfilerStatistics() ? "profile" : "plan";
            visitor.addMetadata(metadataFieldName, (AnyValue)ExecutionPlanConverter.convert(rootPlanTreeNode));
        }
        if ((notifications = this.delegate.getNotifications()).iterator().hasNext()) {
            visitor.addMetadata("notifications", NotificationConverter.convert(notifications));
        }
    }

    private MapValue queryStats(QueryStatistics queryStatistics) {
        HashMap<String, AnyValue> result = new HashMap<String, AnyValue>();
        this.addIfNonZero(result, "nodes-created", queryStatistics.getNodesCreated());
        this.addIfNonZero(result, "nodes-deleted", queryStatistics.getNodesDeleted());
        this.addIfNonZero(result, "relationships-created", queryStatistics.getRelationshipsCreated());
        this.addIfNonZero(result, "relationships-deleted", queryStatistics.getRelationshipsDeleted());
        this.addIfNonZero(result, "properties-set", queryStatistics.getPropertiesSet());
        this.addIfNonZero(result, "labels-added", queryStatistics.getLabelsAdded());
        this.addIfNonZero(result, "labels-removed", queryStatistics.getLabelsRemoved());
        this.addIfNonZero(result, "indexes-added", queryStatistics.getIndexesAdded());
        this.addIfNonZero(result, "indexes-removed", queryStatistics.getIndexesRemoved());
        this.addIfNonZero(result, "constraints-added", queryStatistics.getConstraintsAdded());
        this.addIfNonZero(result, "constraints-removed", queryStatistics.getConstraintsRemoved());
        return VirtualValues.map(result);
    }

    private void addIfNonZero(Map<String, AnyValue> map, String name, int count) {
        if (count > 0) {
            map.put(name, (AnyValue)Values.intValue((int)count));
        }
    }

    private String queryTypeCode(QueryExecutionType.QueryType queryType) {
        switch (queryType) {
            case READ_ONLY: {
                return "r";
            }
            case READ_WRITE: {
                return "rw";
            }
            case WRITE: {
                return "w";
            }
            case SCHEMA_WRITE: {
                return "s";
            }
        }
        return queryType.name();
    }

    private static class NotificationConverter {
        private NotificationConverter() {
        }

        public static AnyValue convert(Iterable<Notification> notifications) {
            ArrayList<MapValue> out = new ArrayList<MapValue>();
            for (Notification notification : notifications) {
                HashMap<String, Object> notificationMap = new HashMap<String, Object>(4);
                notificationMap.put("code", Values.stringValue((String)notification.getCode()));
                notificationMap.put("title", Values.stringValue((String)notification.getTitle()));
                notificationMap.put("description", Values.stringValue((String)notification.getDescription()));
                notificationMap.put("severity", Values.stringValue((String)notification.getSeverity().toString()));
                InputPosition pos = notification.getPosition();
                if (!pos.equals((Object)InputPosition.empty)) {
                    HashMap<String, IntValue> posMap = new HashMap<String, IntValue>(3);
                    posMap.put("offset", Values.intValue((int)pos.getOffset()));
                    posMap.put("line", Values.intValue((int)pos.getLine()));
                    posMap.put("column", Values.intValue((int)pos.getColumn()));
                    notificationMap.put("position", VirtualValues.map(posMap));
                }
                out.add(VirtualValues.map(notificationMap));
            }
            return VirtualValues.fromList(out);
        }
    }
}

