/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.messaging;

import java.io.IOException;
import java.util.Map;
import java.util.stream.Collectors;
import org.neo4j.bolt.v1.messaging.AuthTokenValuesWriter;
import org.neo4j.bolt.v1.messaging.BoltIOException;
import org.neo4j.bolt.v1.messaging.BoltRequestMessage;
import org.neo4j.bolt.v1.messaging.BoltRequestMessageHandler;
import org.neo4j.bolt.v1.messaging.Neo4jPack;
import org.neo4j.bolt.v1.packstream.PackStream;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.values.AnyValue;
import org.neo4j.values.virtual.MapValue;

public class BoltRequestMessageReader {
    private final Neo4jPack.Unpacker unpacker;

    public BoltRequestMessageReader(Neo4jPack.Unpacker unpacker) {
        this.unpacker = unpacker;
    }

    public void read(BoltRequestMessageHandler handler) throws IOException {
        try {
            this.unpacker.unpackStructHeader();
            char signature = this.unpacker.unpackStructSignature();
            BoltRequestMessage message = BoltRequestMessage.withSignature(signature);
            if (message == null) {
                throw new BoltIOException((Status)Status.Request.InvalidFormat, String.format("Message 0x%s is not a valid message signature.", Integer.toHexString(signature)));
            }
            switch (message) {
                case INIT: {
                    String clientName = this.unpacker.unpackString();
                    Map<String, Object> authToken = BoltRequestMessageReader.readAuthToken(this.unpacker);
                    handler.onInit(clientName, authToken);
                    break;
                }
                case ACK_FAILURE: {
                    handler.onAckFailure();
                    break;
                }
                case RESET: {
                    handler.onReset();
                    break;
                }
                case RUN: {
                    String statement = this.unpacker.unpackString();
                    MapValue params = this.unpacker.unpackMap();
                    handler.onRun(statement, params);
                    break;
                }
                case DISCARD_ALL: {
                    handler.onDiscardAll();
                    break;
                }
                case PULL_ALL: {
                    handler.onPullAll();
                    break;
                }
                default: {
                    throw new BoltIOException((Status)Status.Request.InvalidFormat, String.format("Message 0x%s is not supported.", Integer.toHexString(signature)));
                }
            }
        }
        catch (PackStream.PackStreamException e) {
            throw new BoltIOException((Status)Status.Request.InvalidFormat, String.format("Unable to read message type. Error was: %s.", e.getMessage()), e);
        }
    }

    private static Map<String, Object> readAuthToken(Neo4jPack.Unpacker unpacker) throws IOException {
        MapValue authTokenValue = unpacker.unpackMap();
        AuthTokenValuesWriter writer = new AuthTokenValuesWriter();
        return authTokenValue.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> writer.valueAsObject((AnyValue)entry.getValue())));
    }
}

