/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.messaging;

import java.io.IOException;
import java.util.Map;
import org.neo4j.bolt.logging.BoltMessageLogger;
import org.neo4j.bolt.runtime.BoltConnection;
import org.neo4j.bolt.v1.messaging.BoltRequestMessageHandler;
import org.neo4j.bolt.v1.messaging.BoltResponseMessageHandler;
import org.neo4j.bolt.v1.messaging.MessageProcessingHandler;
import org.neo4j.bolt.v1.runtime.Neo4jError;
import org.neo4j.bolt.v1.runtime.spi.BoltResult;
import org.neo4j.cypher.result.QueryResult;
import org.neo4j.logging.Log;
import org.neo4j.values.AnyValue;
import org.neo4j.values.virtual.MapValue;

public class BoltMessageRouter
implements BoltRequestMessageHandler {
    private final BoltMessageLogger messageLogger;
    private final MessageProcessingHandler initHandler;
    private final MessageProcessingHandler runHandler;
    private final MessageProcessingHandler resultHandler;
    private final MessageProcessingHandler defaultHandler;
    private BoltResponseMessageHandler<IOException> output;
    private BoltConnection connection;

    public BoltMessageRouter(Log internalLog, BoltMessageLogger messageLogger, BoltConnection connection, BoltResponseMessageHandler<IOException> output) {
        this.messageLogger = messageLogger;
        this.initHandler = new InitHandler(output, connection, internalLog);
        this.runHandler = new RunHandler(output, connection, internalLog);
        this.resultHandler = new ResultHandler(output, connection, internalLog);
        this.defaultHandler = new MessageProcessingHandler(output, connection, internalLog);
        this.connection = connection;
        this.output = output;
    }

    @Override
    public void onInit(String userAgent, Map<String, Object> authToken) {
        this.messageLogger.logInit(userAgent);
        this.connection.enqueue(session -> session.init(userAgent, authToken, this.initHandler));
    }

    @Override
    public void onAckFailure() {
        this.messageLogger.logAckFailure();
        this.connection.enqueue(session -> session.ackFailure(this.defaultHandler));
    }

    @Override
    public void onReset() {
        this.messageLogger.clientEvent("INTERRUPT");
        this.messageLogger.logReset();
        this.connection.interrupt();
        this.connection.enqueue(session -> session.reset(this.defaultHandler));
    }

    @Override
    public void onRun(String statement, MapValue params) {
        this.messageLogger.logRun();
        this.connection.enqueue(session -> session.run(statement, params, this.runHandler));
    }

    @Override
    public void onExternalError(Neo4jError error) {
        this.messageLogger.clientEvent("ERROR", error::message);
        this.connection.enqueue(session -> session.externalError(error, this.defaultHandler));
    }

    @Override
    public void onDiscardAll() {
        this.messageLogger.logDiscardAll();
        this.connection.enqueue(session -> session.discardAll(this.resultHandler));
    }

    @Override
    public void onPullAll() {
        this.messageLogger.logPullAll();
        this.connection.enqueue(session -> session.pullAll(this.resultHandler));
    }

    private static class ResultHandler
    extends MessageProcessingHandler {
        ResultHandler(BoltResponseMessageHandler<IOException> handler, BoltConnection connection, Log log) {
            super(handler, connection, log);
        }

        @Override
        public void onRecords(BoltResult result, final boolean pull) throws Exception {
            result.accept(new BoltResult.Visitor(){

                @Override
                public void visit(QueryResult.Record record) throws Exception {
                    if (pull) {
                        handler.onRecord(record);
                    }
                }

                @Override
                public void addMetadata(String key, AnyValue value) {
                    metadata.put(key, value);
                }
            });
        }
    }

    private static class RunHandler
    extends MessageProcessingHandler {
        RunHandler(BoltResponseMessageHandler<IOException> handler, BoltConnection connection, Log log) {
            super(handler, connection, log);
        }
    }

    private static class InitHandler
    extends MessageProcessingHandler {
        InitHandler(BoltResponseMessageHandler<IOException> handler, BoltConnection connection, Log log) {
            super(handler, connection, log);
        }
    }
}

