/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.v3_4.planner.logical.idp;

import org.neo4j.cypher.internal.compiler.v3_4.planner.logical.ProjectingSelector;
import org.neo4j.cypher.internal.compiler.v3_4.planner.logical.idp.DefaultIdRegistry;
import org.neo4j.cypher.internal.compiler.v3_4.planner.logical.idp.IDPSolver$;
import org.neo4j.cypher.internal.compiler.v3_4.planner.logical.idp.IDPSolverMonitor;
import org.neo4j.cypher.internal.compiler.v3_4.planner.logical.idp.IDPSolverStep;
import org.neo4j.cypher.internal.compiler.v3_4.planner.logical.idp.IDPTable;
import org.neo4j.cypher.internal.compiler.v3_4.planner.logical.idp.IdRegistry;
import org.neo4j.cypher.internal.planner.v3_4.spi.PlanningAttributes;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.BitSet;
import scala.collection.immutable.BitSet$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.Vector;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0001\u0005}e\u0001B\u0001\u0003\u0001U\u0011\u0011\"\u0013#Q'>dg/\u001a:\u000b\u0005\r!\u0011aA5ea*\u0011QAB\u0001\bY><\u0017nY1m\u0015\t9\u0001\"A\u0004qY\u0006tg.\u001a:\u000b\u0005%Q\u0011\u0001\u0002<4?RR!a\u0003\u0007\u0002\u0011\r|W\u000e]5mKJT!!\u0004\b\u0002\u0011%tG/\u001a:oC2T!a\u0004\t\u0002\r\rL\b\u000f[3s\u0015\t\t\"#A\u0003oK>$$NC\u0001\u0014\u0003\ry'oZ\u0002\u0001+\u00111Re\f\u001a\u0014\u0005\u00019\u0002C\u0001\r\u001c\u001b\u0005I\"\"\u0001\u000e\u0002\u000bM\u001c\u0017\r\\1\n\u0005qI\"AB!osJ+g\r\u0003\u0005\u001f\u0001\t\u0005\t\u0015!\u0003 \u0003%9WM\\3sCR|'\u000fE\u0003!C\rr\u0013'D\u0001\u0003\u0013\t\u0011#AA\u0007J\tB\u001bv\u000e\u001c<feN#X\r\u001d\t\u0003I\u0015b\u0001\u0001B\u0003'\u0001\t\u0007qE\u0001\u0005T_24\u0018M\u00197f#\tA3\u0006\u0005\u0002\u0019S%\u0011!&\u0007\u0002\b\u001d>$\b.\u001b8h!\tAB&\u0003\u0002.3\t\u0019\u0011I\\=\u0011\u0005\u0011zC!\u0002\u0019\u0001\u0005\u00049#A\u0002*fgVdG\u000f\u0005\u0002%e\u0011)1\u0007\u0001b\u0001O\t91i\u001c8uKb$\b\u0002C\u001b\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001c\u0002%A\u0014xN[3di&twmU3mK\u000e$xN\u001d\t\u0004oarS\"\u0001\u0003\n\u0005e\"!A\u0005)s_*,7\r^5oON+G.Z2u_JD\u0001b\u000f\u0001\u0003\u0002\u0003\u0006I\u0001P\u0001\u0010e\u0016<\u0017n\u001d;ss\u001a\u000b7\r^8ssB\u0019\u0001$P \n\u0005yJ\"!\u0003$v]\u000e$\u0018n\u001c81!\r\u0001\u0003iI\u0005\u0003\u0003\n\u0011!\"\u00133SK\u001eL7\u000f\u001e:z\u0011!\u0019\u0005A!A!\u0002\u0013!\u0015\u0001\u0004;bE2,g)Y2u_JL\b#\u0002\rF\u007f\u001ds\u0015B\u0001$\u001a\u0005%1UO\\2uS>t'\u0007\u0005\u0003I\u0017\u000ercB\u0001\u0011J\u0013\tQ%!A\u0004qC\u000e\\\u0017mZ3\n\u00051k%\u0001B*fK\u0012T!A\u0013\u0002\u0011\u0007\u0001ze&\u0003\u0002Q\u0005\tA\u0011\n\u0012)UC\ndW\r\u0003\u0005S\u0001\t\u0005\t\u0015!\u0003T\u00031i\u0017\r\u001f+bE2,7+\u001b>f!\tAB+\u0003\u0002V3\t\u0019\u0011J\u001c;\t\u0011]\u0003!\u0011!Q\u0001\na\u000ba#\u001b;fe\u0006$\u0018n\u001c8EkJ\fG/[8o\u0019&l\u0017\u000e\u001e\t\u00031eK!AW\r\u0003\t1{gn\u001a\u0005\t9\u0002\u0011\t\u0011)A\u0005;\u00069Qn\u001c8ji>\u0014\bC\u0001\u0011_\u0013\ty&A\u0001\tJ\tB\u001bv\u000e\u001c<fe6{g.\u001b;pe\")\u0011\r\u0001C\u0001E\u00061A(\u001b8jiz\"\u0002b\u00193fM\u001eD\u0017N\u001b\t\u0006A\u0001\u0019c&\r\u0005\u0006=\u0001\u0004\ra\b\u0005\u0006k\u0001\u0004\rA\u000e\u0005\bw\u0001\u0004\n\u00111\u0001=\u0011\u001d\u0019\u0005\r%AA\u0002\u0011CQA\u00151A\u0002MCQa\u00161A\u0002aCQ\u0001\u00181A\u0002uCQ\u0001\u001c\u0001\u0005\u00025\fQ!\u00199qYf$\u0012B\\A\u0004\u0003\u0017\ty!a\u0005\u0011\u0007=4\u0018P\u0004\u0002qk:\u0011\u0011\u000f^\u0007\u0002e*\u00111\u000fF\u0001\u0007yI|w\u000e\u001e \n\u0003iI!AS\r\n\u0005]D(\u0001C%uKJ\fGo\u001c:\u000b\u0005)K\u0002\u0003\u0002\r{y:J!a_\r\u0003\rQ+\b\u000f\\33!\u0011i\u0018\u0011A\u0012\u000f\u0005aq\u0018BA@\u001a\u0003\u0019\u0001&/\u001a3fM&!\u00111AA\u0003\u0005\r\u0019V\r\u001e\u0006\u0003\u007ffAa!!\u0003l\u0001\u00049\u0015\u0001B:fK\u0012Da!!\u0004l\u0001\u0004a\u0018aC5oSRL\u0017\r\u001c+p\t>Da!!\u0005l\u0001\u0004\t\u0014aB2p]R,\u0007\u0010\u001e\u0005\b\u0003+Y\u0007\u0019AA\f\u0003\u001d\u0019x\u000e\u001c<fIN\u0004B!!\u0007\u0002D9!\u00111DA\u001f\u001d\u0011\ti\"a\u000e\u000f\t\u0005}\u00111\u0007\b\u0005\u0003C\t\tD\u0004\u0003\u0002$\u0005=b\u0002BA\u0013\u0003[qA!a\n\u0002,9\u0019\u0011/!\u000b\n\u0003MI!!\u0005\n\n\u0005=\u0001\u0012BA\u0007\u000f\u0013\t9A\"C\u0002\n\u0003kQ!a\u0002\u0007\n\t\u0005e\u00121H\u0001\u0004gBL'bA\u0005\u00026%!\u0011qHA!\u0003I\u0001F.\u00198oS:<\u0017\t\u001e;sS\n,H/Z:\u000b\t\u0005e\u00121H\u0005\u0005\u0003\u000b\n9EA\u0004T_24X\rZ:\u000b\t\u0005}\u0012\u0011I\u0004\n\u0003\u0017\u0012\u0011\u0011!E\u0001\u0003\u001b\n\u0011\"\u0013#Q'>dg/\u001a:\u0011\u0007\u0001\nyE\u0002\u0005\u0002\u0005\u0005\u0005\t\u0012AA)'\r\tye\u0006\u0005\bC\u0006=C\u0011AA+)\t\ti\u0005\u0003\u0006\u0002Z\u0005=\u0013\u0013!C\u0001\u00037\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\u001aT\u0003CA/\u0003W\ny(!!\u0016\u0005\u0005}#\u0006BA1\u0003[\u0002B\u0001G\u001f\u0002dA)\u0001%!\u001a\u0002j%\u0019\u0011q\r\u0002\u0003#\u0011+g-Y;mi&#'+Z4jgR\u0014\u0018\u0010E\u0002%\u0003W\"aAJA,\u0005\u000493FAA8!\u0011\t\t(a\u001f\u000e\u0005\u0005M$\u0002BA;\u0003o\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005e\u0014$\u0001\u0006b]:|G/\u0019;j_:LA!! \u0002t\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0005\rA\n9F1\u0001(\t\u0019\u0019\u0014q\u000bb\u0001O!Q\u0011QQA(#\u0003%\t!a\"\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00135+!\tI)a%\u0002\u001a\u0006uUCAAFU\u0011\ti)!\u001c\u0011\u0011a)\u0015qRAK\u00037\u0003B\u0001\t!\u0002\u0012B\u0019A%a%\u0005\r\u0019\n\u0019I1\u0001(!\u0019A5*!%\u0002\u0018B\u0019A%!'\u0005\rA\n\u0019I1\u0001(!\u0011\u0001s*a&\u0005\rM\n\u0019I1\u0001(\u0001")
public class IDPSolver<Solvable, Result, Context> {
    private final IDPSolverStep<Solvable, Result, Context> generator;
    public final ProjectingSelector<Result> org$neo4j$cypher$internal$compiler$v3_4$planner$logical$idp$IDPSolver$$projectingSelector;
    private final Function0<IdRegistry<Solvable>> registryFactory;
    private final Function2<IdRegistry<Solvable>, Iterable<Tuple2<Set<Solvable>, Result>>, IDPTable<Result>> tableFactory;
    private final int maxTableSize;
    private final long iterationDurationLimit;
    private final IDPSolverMonitor monitor;

    public static <Solvable, Result, Context> Function2<IdRegistry<Solvable>, Iterable<Tuple2<Set<Solvable>, Result>>, IDPTable<Result>> $lessinit$greater$default$4() {
        return IDPSolver$.MODULE$.$lessinit$greater$default$4();
    }

    public static <Solvable, Result, Context> Function0<DefaultIdRegistry<Solvable>> $lessinit$greater$default$3() {
        return IDPSolver$.MODULE$.$lessinit$greater$default$3();
    }

    public Iterator<Tuple2<Set<Solvable>, Result>> apply(Iterable<Tuple2<Set<Solvable>, Result>> seed, Set<Solvable> initialToDo, Context context, PlanningAttributes.Solveds solveds) {
        IdRegistry registry = (IdRegistry)this.registryFactory.apply();
        IDPTable table = (IDPTable)this.tableFactory.apply((Object)registry, seed);
        ObjectRef toDo = ObjectRef.create((Object)registry.registerAll(initialToDo));
        Serializable goalSelector = new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ IDPSolver $outer;

            public final Option<Tuple2<BitSet, Result>> apply(Iterable<Tuple2<BitSet, Result>> x$2) {
                return this.$outer.org$neo4j$cypher$internal$compiler$v3_4$planner$logical$idp$IDPSolver$$projectingSelector.apply(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Result apply(Tuple2<BitSet, Result> x$1) {
                        return (Result)x$1._2();
                    }
                }, x$2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
        int iterations = 0;
        while (((BitSet)toDo.elem).size() > 1) {
            this.monitor.startIteration(++iterations);
            int largestBlockSize = this.generateBestCandidates$1(((BitSet)toDo.elem).size(), context, solveds, registry, table, toDo);
            if (largestBlockSize <= 0) {
                throw new IllegalStateException(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unfortunately, the planner was unable to find a plan within the constraints provided.\n          |Try increasing the config values `", "`\n          |and `", "` to allow\n          |for a larger sub-plan table and longer planning time."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{GraphDatabaseSettings.cypher_idp_solver_table_threshold.name(), GraphDatabaseSettings.cypher_idp_solver_duration_threshold.name()})))).stripMargin());
            }
            Tuple2 tuple2 = this.findBestCandidateInBlock$1(largestBlockSize, table, (Function1)goalSelector);
            if (tuple2 != null) {
                Tuple2 tuple22;
                BitSet bestGoal = (BitSet)tuple2._1();
                Object bestInBlock = tuple2._2();
                Tuple2 tuple23 = tuple22 = new Tuple2((Object)bestGoal, bestInBlock);
                BitSet bestGoal2 = (BitSet)tuple23._1();
                Object bestInBlock2 = tuple23._2();
                this.monitor.endIteration(iterations, largestBlockSize, table.size());
                this.compactBlock$1(bestGoal2, bestInBlock2, registry, table, toDo);
                continue;
            }
            throw new MatchError((Object)tuple2);
        }
        this.monitor.foundPlanAfter(iterations);
        return table.plans().map((Function1)new Serializable(this, registry){
            public static final long serialVersionUID = 0L;
            private final IdRegistry registry$1;

            public final Tuple2<Set<Solvable>, Result> apply(Tuple2<BitSet, Result> x0$1) {
                Tuple2<BitSet, Result> tuple2 = x0$1;
                if (tuple2 != null) {
                    BitSet k = (BitSet)tuple2._1();
                    Object v = tuple2._2();
                    Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.registry$1.explode(k)), v);
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
            {
                this.registry$1 = registry$1;
            }
        });
    }

    private final int generateBestCandidates$1(int maxBlockSize, Object context$1, PlanningAttributes.Solveds solveds$1, IdRegistry registry$1, IDPTable table$1, ObjectRef toDo$1) {
        int largestFinishedIteration = 0;
        int blockSize = 1;
        boolean keepGoing = true;
        long start = System.currentTimeMillis();
        while (keepGoing && blockSize <= maxBlockSize) {
            BooleanRef foundNoCandidate = BooleanRef.create((boolean)true);
            Iterator goals = ((BitSet)toDo$1.elem).subsets(++blockSize);
            while (keepGoing && goals.hasNext()) {
                BitSet goal = (BitSet)goals.next();
                if (table$1.contains(goal)) continue;
                Vector candidates2 = this.generator.apply(registry$1, goal, table$1, context$1, solveds$1).toVector();
                this.org$neo4j$cypher$internal$compiler$v3_4$planner$logical$idp$IDPSolver$$projectingSelector.apply((Iterable<Result>)candidates2).foreach((Function1)new Serializable(this, table$1, foundNoCandidate, goal){
                    public static final long serialVersionUID = 0L;
                    private final IDPTable table$1;
                    private final BooleanRef foundNoCandidate$1;
                    private final BitSet goal$1;

                    public final void apply(Result candidate) {
                        this.foundNoCandidate$1.elem = false;
                        this.table$1.put(this.goal$1, candidate);
                    }
                    {
                        void var4_4;
                        void var3_3;
                        this.table$1 = table$1;
                        this.foundNoCandidate$1 = var3_3;
                        this.goal$1 = var4_4;
                    }
                });
                keepGoing = blockSize == 2 || table$1.size() <= this.maxTableSize && System.currentTimeMillis() - start < this.iterationDurationLimit;
            }
            largestFinishedIteration = foundNoCandidate.elem || goals.hasNext() ? largestFinishedIteration : blockSize;
        }
        return largestFinishedIteration;
    }

    private final Tuple2 findBestCandidateInBlock$1(int blockSize, IDPTable table$1, Function1 goalSelector$1) {
        Vector blockCandidates = table$1.plansOfSize(blockSize).toVector();
        Option bestInBlock = (Option)goalSelector$1.apply((Object)blockCandidates);
        return (Tuple2)bestInBlock.getOrElse((Function0)new Serializable(this, table$1, blockSize, (Iterable)blockCandidates){
            public static final long serialVersionUID = 0L;
            private final IDPTable table$1;
            private final int blockSize$1;
            private final Iterable blockCandidates$1;

            public final Nothing$ apply() {
                throw new IllegalStateException(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Found no solution for block with size ", ",\n              |", " were the selected candidates from the table ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.blockSize$1), this.blockCandidates$1, this.table$1})))).stripMargin());
            }
            {
                void var4_4;
                this.table$1 = table$1;
                this.blockSize$1 = blockSize$1;
                this.blockCandidates$1 = var4_4;
            }
        });
    }

    private final void compactBlock$1(BitSet original, Object candidate, IdRegistry registry$1, IDPTable table$1, ObjectRef toDo$1) {
        int newId = registry$1.compact(original);
        table$1.put(BitSet$.MODULE$.empty().$plus(newId), candidate);
        toDo$1.elem = ((BitSet)((BitSet)toDo$1.elem).$minus$minus((GenTraversableOnce)original)).$plus(newId);
        table$1.removeAllTracesOf(original);
    }

    public IDPSolver(IDPSolverStep<Solvable, Result, Context> generator, ProjectingSelector<Result> projectingSelector, Function0<IdRegistry<Solvable>> registryFactory, Function2<IdRegistry<Solvable>, Iterable<Tuple2<Set<Solvable>, Result>>, IDPTable<Result>> tableFactory, int maxTableSize, long iterationDurationLimit, IDPSolverMonitor monitor) {
        this.generator = generator;
        this.org$neo4j$cypher$internal$compiler$v3_4$planner$logical$idp$IDPSolver$$projectingSelector = projectingSelector;
        this.registryFactory = registryFactory;
        this.tableFactory = tableFactory;
        this.maxTableSize = maxTableSize;
        this.iterationDurationLimit = iterationDurationLimit;
        this.monitor = monitor;
    }
}

