/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.store;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.neo4j.kernel.impl.store.GeometryType;
import org.neo4j.kernel.impl.store.PropertyType;
import org.neo4j.kernel.impl.store.ShortArray;
import org.neo4j.kernel.impl.store.TemporalType;
import org.neo4j.kernel.impl.util.Bits;
import org.neo4j.string.UTF8;
import org.neo4j.values.storable.ArrayValue;
import org.neo4j.values.storable.ByteArray;
import org.neo4j.values.storable.TextArray;
import org.neo4j.values.storable.Values;

public class PropertyUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayValue readArrayFromBuffer(ByteBuffer buffer) {
        if (buffer.limit() <= 0) {
            throw new IllegalStateException("Given buffer is empty");
        }
        byte typeId = buffer.get();
        buffer.order(ByteOrder.BIG_ENDIAN);
        try {
            if (typeId == PropertyType.STRING.intValue()) {
                int arrayLength = buffer.getInt();
                String[] result = new String[arrayLength];
                for (int i = 0; i < arrayLength; ++i) {
                    int byteLength = buffer.getInt();
                    result[i] = UTF8.decode((byte[])buffer.array(), (int)buffer.position(), (int)byteLength);
                    buffer.position(buffer.position() + byteLength);
                }
                TextArray i = Values.stringArray((String[])result);
                return i;
            }
            if (typeId == PropertyType.GEOMETRY.intValue()) {
                GeometryType.GeometryHeader header = GeometryType.GeometryHeader.fromArrayHeaderByteBuffer(buffer);
                byte[] byteArray = new byte[buffer.limit() - buffer.position()];
                buffer.get(byteArray);
                ArrayValue i = GeometryType.decodeGeometryArray(header, byteArray);
                return i;
            }
            if (typeId == PropertyType.TEMPORAL.intValue()) {
                TemporalType.TemporalHeader header = TemporalType.TemporalHeader.fromArrayHeaderByteBuffer(buffer);
                byte[] byteArray = new byte[buffer.limit() - buffer.position()];
                buffer.get(byteArray);
                ArrayValue i = TemporalType.decodeTemporalArray(header, byteArray);
                return i;
            }
            ShortArray type = ShortArray.typeOf(typeId);
            byte bitsUsedInLastByte = buffer.get();
            byte requiredBits = buffer.get();
            if (requiredBits == 0) {
                ArrayValue byteLength = type.createEmptyArray();
                return byteLength;
            }
            if (type == ShortArray.BYTE && requiredBits == 8) {
                byte[] byteArray = new byte[buffer.limit() - buffer.position()];
                buffer.get(byteArray);
                ByteArray byteArray2 = Values.byteArray((byte[])byteArray);
                return byteArray2;
            }
            Bits bits = Bits.bitsFromBytes(buffer.array(), buffer.position());
            int length = ((buffer.limit() - buffer.position()) * 8 - (8 - bitsUsedInLastByte)) / requiredBits;
            ArrayValue arrayValue = type.createArray(length, bits, requiredBits);
            return arrayValue;
        }
        finally {
            buffer.order(ByteOrder.LITTLE_ENDIAN);
        }
    }
}

